<?php
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: login.php");
}

include 'include/head.php';
include 'include/navigation.php';
?>

    <!-- Page Content -->
    <div id="page-wrapper">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <h1 class="page-header">Bienvenue <?php echo htmlspecialchars($_SESSION['user']) ?></h1>
                </div>
                <!-- /.col-lg-12 -->
            </div>
            <!-- /.row -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            Liste des élèves (cliquez sur un nom pour modifier)
                        </div>
                        <!-- /.panel-heading -->
                        <div class="panel-body">
                            <div class="dataTable_wrapper">
                                <table class="table table-striped table-bordered table-hover" id="dataTables-example">
                                    <thead>
                                    <tr>
                                        <th>Nom</th>
                                        <th>Naissance</th>
                                        <th>Inscription</th>
                                        <th>Préc</th>
                                        <th>Adresse</th>
                                        <th>Téléphones</th>
                                        <th>Responsable</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    $result = $bdd->query("SELECT * FROM eleve");
                                    while ( $ligne = $result->fetch())
                                    {
                                        $responsable = '';
                                        $requete = $bdd->prepare("SELECT nom_responsable, prenom_responsable FROM responsable WHERE id_eleve=:id");
                                        $requete->bindParam(':id', $ligne['id_eleve']);
                                        $requete->execute();
                                        while ( $row = $requete->fetch())
                                            $responsable .= $row['prenom_responsable'].' '.$row['nom_responsable'];
                                        ?>
                                        <tr class="odd">
                                            <td><a href="edition-eleve.php?id=<?php echo htmlspecialchars($ligne['id_eleve']) ?>"><?php echo htmlspecialchars($ligne['nom'].' '.$ligne['prenom']) ?></a><br /><?php echo htmlspecialchars($ligne['matricule']) ?><br /><a href="bulletin.php?id=<?php echo htmlspecialchars($ligne['id_eleve']) ?>">Bulletin</a></td>
                                            <td><?php echo htmlspecialchars($ligne['naissance']) ?></td>
                                            <td><?php echo htmlspecialchars($ligne['inscription']) ?></td>
                                            <td><?php echo htmlspecialchars($ligne['etablissement_precedent']) ?></td>
                                            <td><?php echo htmlspecialchars($ligne['num_rue']). ' '.htmlspecialchars($ligne['cp']). ' '.htmlspecialchars($ligne['ville']) ?></td>
                                            <td><?php echo htmlspecialchars($ligne['tel_mobile']).'<br />'.htmlspecialchars($ligne['tel_domicile']) ?></td>
                                            <td><?php echo htmlspecialchars($responsable) ?></td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>
                                </table>
                            </div>
                            <!-- /.table-responsive -->
                        </div>
                        <!-- /.panel-body -->
                    </div>
                    <!-- /.panel -->
                </div>
                <!-- /.col-lg-12 -->
            </div>
        </div>
        <!-- /.container-fluid -->
    </div>
    <!-- /#page-wrapper -->

<?php
include 'include/foot.php';
